
//scilab 5.5.2 , OS: Ubuntu 14.04
// Circular convolution of given discrete sequences in time domain (Matrix method)
clear;clc;
x1=input ('enter the first sequence values x1(n)= ');    // [1 2 3 4]
x2=input('enter the second sequence values x2(n) = ');   //[1 -1 0 -1]
L1 = length(x1);                         //length of first sequence
L2 = length(x2);                         //length of second sequence

if (L1 >L2)                      	  //To make length of x1 and x2 are Equal 
   for i = L2+1:L1
     x2(i) = 0;
   end
elseif (L2>L1)
   for i = L1+1:L2
     x1(i) = 0;
   end
end

N = length(x1);
x3 = zeros(1,N);                           //x3 = Circular convolution result
a(1) = x2(1);
for j = 2:N
  a(j) = x2(N-j+2);
end
for i =1:N
  x3(1) = x3(1)+x1(i)*a(i);
end
X(1,:)=a;

//Calculation of circular convolution
for k = 2:N
    for j =2:N
       x2(j) = a(j-1);
    end
       x2(1) = a(N);
       X(k,:)= x2;
    for i = 1:N
        a(i) = x2(i);
        x3(k) = x3(k)+x1(i)*a(i);
    end
end
disp(X,'Circular Convolution Matrix x2[n]=')
disp(x3,'Circular Convolution Result x3[n] = ')
// Expected result
//Circular Convolution Matrix x2[n]=   
 
//    1.  - 1.    0.  - 1.  
//  - 1.    1.  - 1.    0.  
//    0.  - 1.    1.  - 1.  
//  - 1.    0.  - 1.    1.  
 
 //Circular Convolution Result x3[n] =    
 
 // -5.  -2.  -3.    0.  

// Circular Convolution in frequency domain (DFT-IDFT method)
clear all;clc;close;
x1=input ('enter the first sequence values x1(n)= ');   // [1 2 3 4]
x2=input('enter the second sequence values x2(n) = '); //[1 -1 0 -1]
L=input ('enter the length of the sequence values L= '); //4

//Computing DFT 
X1 = fft(x1,-1);         			//-1 for direct FFT
X2 = fft(x2,-1);
disp(X1,'DFT of x1[n] is X1(k)=')
disp(X2,'DFT of x2[n] is X2(k)=')

//Multiplication of 2 DFTs
X3 = X1.*X2;
disp(X3,'DFT of x3[n] is X3(k)=')
x3 =(fft(X3,1))   	                         //Circular Convolution Result ,1 for IFFT
disp(x3,'Circular Convolution x3[n]=')
//// Expected result
//DFT of x1[n] is X1(k)=       10.  - 2. + 2.i  - 2.  - 2. - 2.i  
 
 //DFT of x1[n] is X2(k)=     - 1.    1.    3.    1.  
 
// DFT of x3[n] is X3(k)=     - 10.  - 2. + 2.i  - 6.  - 2. - 2.i  
 
 //Circular Convolution x3[n]=       -5.    -2.    -3.    0.  
 
////Performing Linear Convolution using Circular Convolution
clear;clc;
x=input ('enter the input sequence values x(n)= ');   // [1 2 3 4]
h=input('enter the impulse sequence values h(n) = ');   //[1 -1 0 -1]
N1 = length(x); 		//Length of input signal
N2 = length(h);		//Length of impulse response 

N = N1+N2-1                         // Length of output response
disp(N,'Length of Output Response y(n)')

//Padding zeros to Make Length of 'h' and 'x' equal to length of output response 'y'

h1 = [h,zeros(1,N-N2)];
x1 = [x,zeros(1,N-N1)];

H = fft(h1,-1);
X = fft(x1,-1);
//Multiplication of 2 DFTs
Y = X.*H
y =(fft(Y,1))			//Linear Convolution Result

disp(X,'DFT of i/p X(k)=')
disp(H,'DFT of impulse sequence H(k)=')
disp(Y,'DFT of Linear Filter o/p Y(k)=')
disp(y,'Linear Convolution result y[n]=')

//Expected output
//Length of Output Response y(n)       7.  
 
 //DFT of i/p X(k)=       10.  - 2.0244587 - 6.2239817i  ,    0.3460107 + 2.4791213i  ,    0.1784479 - 2.4219847i  ,    0.1784479 + 2.4219847i  ,    0.3460107 - 2.4791213i  ,  - 2.0244587 + 6.2239817i  , 
 //DFT of impulse sequence H(k)=     - 1.    1.2774791 + 1.2157152i  ,,   0.5990311 + 0.1930964i  ,    2.1234898 + 1.4088117i  ,    2.1234898 - 1.4088117i  ,    0.5990311 - 0.1930964i  ,    1.2774791 - 1.2157152i  ,
  //DFT of Linear Filter o/p Y(k)=     - 10.    4.9803857 - 10.412171i  ,  - 0.2714383 + 1.5518843i  ,   3.7910526 - 4.8916602i  ,    3.7910526 + 4.8916602i  ,  - 0.2714383 - 1.5518843i  ,    4.9803857 + 10.412171i  , 
 //Linear Convolution result y[n]=       1.    1.    1.    0.    -6.   -3.    -4.  
 
